# String


![Gitlab Pipeline Status](https://img.shields.io/gitlab/pipeline-status/project%2Fstring?gitlab_url=https%3A%2F%2Fgit.drupalcode.org&branch=1.1.x&style=flat-square&logo=gitlab) 
![Gitlab Code Coverage](https://img.shields.io/gitlab/pipeline-coverage/project%2Fstring?gitlab_url=https%3A%2F%2Fgit.drupalcode.org&branch=1.1.x&style=flat-square) 
![GitLab Tag](https://img.shields.io/gitlab/v/tag/project%2Fstring?gitlab_url=https%3A%2F%2Fgit.drupalcode.org&style=flat-square) 
![GitLab Contributors](https://img.shields.io/gitlab/contributors/project%2Fstring?gitlab_url=https%3A%2F%2Fgit.drupalcode.org&style=flat-square)

A Drupal module for managing and translating strings using "Keyword" philosophy.

```php
<?php
$this->t('Drupal is great');

$this->t('drupal.great');
```

In the first method, messages are written in the language of the default locale (English in this case). That message is then used as the "id" when creating translations.

In the second method, messages are actually "keywords" that convey the idea of the message. The keyword message is then used as the "id" for any translations. In this case, translations must be made for the default locale (i.e. to translate `drupal.great` to `Drupal is great`).


String enables developers to,

- define Keyword (i.e. `drupal.great`)
- optionally provide a default value `Drupal is great`
- integrate with core's translation api so that it works well with `t` function, locale import/export, editing interface translation, etc.

## Documentation

For detailed documentation, please visit our [documentation site](https://project.pages.drupalcode.org/string/).

### Quick Links

- [Installation Guide](https://project.pages.drupalcode.org/string/getting-started/installation/)
- [Basic Usage](https://project.pages.drupalcode.org/string/user-guide/basic-usage/)
- [Contributing Guide](https://project.pages.drupalcode.org/string//contributing/how-to-contribute/)

## Support

- [Issue Queue](https://www.drupal.org/project/issues/string)
- [Drupal Slack](https://www.drupal.org/slack)

## Sample usage

| Current (Core) | String |
|---|---|
| `t('Dashboard')` | `t('dashboard.title')` |
| `t('My Dashboard')` | `t('user_dashboard.title')` |
| `t('Welcome @name!', ['@name' => $name])` | `t('dashboard.welcome_message.title', ['@name' => $name])` |
| `format_plural($count, '1 item', '@count items')` | `format_plural($count, 'search_result.item_count', 'search_result.item_count')` |
