# Contributing to String Module

Thank you for your interest in contributing to the String module! 

After selecting appropriate Issue on String Modules issue queue in Drupal.org you may start development by generating a branch from the issue queue.

## Development Environment Setup

### 1. Install DDEV

```bash
# macOS
brew install ddev

# Windows
winget install DDEV.DDEV

# Linux
curl -fsSL https://raw.githubusercontent.com/ddev/ddev/master/scripts/install_ddev.sh | bash
```

### 2. Clone and Setup

```bash
# Clone the repository
git clone https://git.drupalcode.org/project/string.git
cd string

# Start DDEV
ddev start

# Install dependencies
composer install
```

## Development Workflow

1. **Create a New Branch**:
   ```bash
   git checkout -b issue-number-short-description
   # Example: git checkout -b 123456-fix-string-export
   ```

## Getting Help

- [Issue Queue](https://www.drupal.org/project/issues/string)
- [Drupal Slack](https://www.drupal.org/slack)
