# Installation Guide

This guide will walk you through the process of installing and configuring the String module.

## Prerequisites

Before installing the String module, ensure you have:

- A working Drupal 10.3 or 11.x installation
- PHP 8.1 or higher
- Composer installed
- Drush installed (optional, but recommended)

## Installation Methods

### Using Composer (Recommended)

1. Navigate to your Drupal root directory:
   ```bash
   cd /path/to/drupal
   ```

2. Install the module using Composer:
   ```bash
   composer require drupal/string
   ```

3. Enable the module using Drush:
   ```bash
   drush en string
   ```
   
   Or through the Drupal admin interface:
   - Go to Extend (`/admin/modules`)
   - Find "String" in the list
   - Check the box and click "Install"

### Manual Installation

1. Download the latest release from [Drupal.org](https://www.drupal.org/project/string)
2. Extract the archive to your Drupal's `modules` directory
3. Enable the module through the Drupal admin interface or using Drush

## Configuration

### Basic Configuration

1. Navigate to the String module settings:
   - Go to Configuration → Regional and language → String settings
   - Or visit `/admin/config/regional/string`

2. Configure the following settings:
   - String export format
   - Default string namespace
   - Translation workflow settings

### Permissions

The module adds several permissions that you may want to configure:

- `manage string export`: Allows users to export string translations
- `import string translations`: Allows users to import string translations
- `administer string settings`: Allows users to configure the module

To configure permissions:
1. Go to People → Permissions (`/admin/people/permissions`)
2. Find the "String" section
3. Configure permissions for each role

## Verification

To verify the installation:

1. Check the status report:
   - Go to Reports → Status report (`/admin/reports/status`)
   - Look for the String module in the list

2. Test the basic functionality:
   - Create a test string in your custom module
   - Verify it appears in the string management interface
   - Try exporting and importing translations

## Troubleshooting

If you encounter any issues during installation:

1. Check the Drupal error log
2. Verify all prerequisites are met
3. Clear the Drupal cache:
   ```bash
   drush cr
   ```
4. Check the [issue queue](https://www.drupal.org/project/issues/string) for known issues

## Next Steps

After installation, you may want to:

1. Review the [Quick Start Guide](quick-start.md)
2. Learn about [Basic Usage](../user-guide/basic-usage.md)