# String TGMT

A Drupal module that provides integration between the String module and [Translation Management Tool(TMGMT)](https://www.drupal.org/project/tmgmt) ecosystem.

## Overview

The String TGMT allows you to manage and translate strings defined through the String module's YAML-based string definitions using TMGMT's powerful translation workflow.

## Features

- Integration with TMGMT for professional translation workflows
- Source handler for strings defined via String module
- Additional metadata like comments and information about placeholders re exported appropriately
- Dedicated interface for browsing and managing string translations
- Support for both single and plural string translations
- Maintains compatibility with Drupal's locale system

## Requirements

- Drupal 10.3 or higher
- String module
- TMGMT module
- TMGMT Locale module
- Locale module

## Installation

1. Install the module using Composer:
   ```bash
   composer require drupal/string_tmgmt
   ```

2. Enable the module through the Drupal admin interface or using Drush:
   ```bash
   drush en string_tmgmt
   ```

## Usage

### Accessing String Translations

1. Navigate to the TMGMT interface
2. Create a new translation job
3. Select "String" as the source
4. Choose the target language
5. Select the strings you want to translate
6. Submit the job for translation

### String Source Plugin

The module provides a source plugin for TMGMT that specifically handles strings defined through the String module. This plugin:

- Integrates with the String module's YAML-based string definitions
- Supports both single and plural string translations
- Maintains context information for accurate translations
- Provides a dedicated UI for browsing string translations

### Translation Workflow

1. Strings defined in your module's `.string.yml` files are automatically available for translation
2. Use TMGMT's interface to create translation jobs
3. Assign translators to the jobs
4. Review and accept translations
5. Translations are automatically integrated into your site

## Integration with String Module

The String TGMT module works seamlessly with the String module's features:

- Supports all string definition formats from `.string.yml` files
- Maintains the namespace.key structure for string identifiers
- Preserves context information for accurate translations
- Supports both single and plural string forms


## Related Modules

- [String](https://www.drupal.org/project/string) - Base module for string management
- [TMGMT](https://www.drupal.org/project/tmgmt) - Translation Management system
- [TMGMT Locale](https://www.drupal.org/project/tmgmt_locale) - Locale integration for TMGMT

## Support

For issues and feature requests, please use the [issue queue](https://www.drupal.org/project/issues/string) on Drupal.org.
