<?php

namespace Drupal\string_i18next\Plugin\rest\resource;

use Drupal\rest\Plugin\ResourceBase;
use Drupal\rest\ResourceResponse;
use Drupal\string_i18next\StringI18Next;
use Psr\Log\LoggerInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides a String Resource.
 *
 * @RestResource(
 *   id = "string_i18next",
 *   label = @Translation("String i18next Item"),
 *   uri_paths = {
 *     "canonical" = "/api/v1/string/i18next/{language_code}/{id}"
 *   }
 * )
 */
class StringResource extends ResourceBase {

  /**
   * The string i18next service.
   *
   * @var \Drupal\string_i18next\StringI18Next
   */
  protected $stringI18Next;

  /**
   * Constructs a Drupal\rest\Plugin\ResourceBase object.
   *
   * @param array $configuration
   *   A configuration array containing information about the plugin instance.
   * @param string $plugin_id
   *   The plugin_id for the plugin instance.
   * @param mixed $plugin_definition
   *   The plugin implementation definition.
   * @param array $serializer_formats
   *   The available serialization formats.
   * @param \Psr\Log\LoggerInterface $logger
   *   A logger instance.
   * @param \Drupal\string_i18next\StringI18Next $string_i18next
   *   String Manager instance.
   */
  public function __construct(array $configuration, $plugin_id, $plugin_definition, array $serializer_formats, LoggerInterface $logger, StringI18Next $string_i18next) {
    parent::__construct($configuration, $plugin_id, $plugin_definition, $serializer_formats, $logger);
    $this->stringI18Next = $string_i18next;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->getParameter('serializer.formats'),
      $container->get('logger.factory')->get('rest'),
      $container->get('string_i18next')
    );
  }

  /**
   * Responds to entity GET requests.
   */
  public function get($language_code, $id) {
    $items = explode('.', $id);
    $strings = $this->stringI18Next->getStrings($language_code);
    $filtered_strings = $strings;
    foreach ($items as $key) {
      if (isset($filtered_strings[$key])) {
        $filtered_strings = $filtered_strings[$key];
      }
      else {
        return new ResourceResponse([], '404');
      }
    }
    return new ResourceResponse($filtered_strings);
  }

}
