<?php

namespace Drupal\string_tmgmt\Plugin\tmgmt\Source;

use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\tmgmt\JobItemInterface;
use Drupal\tmgmt_locale\Plugin\tmgmt\Source\LocaleSource;

/**
 * Translation Source plugin for locale strings.
 *
 * @SourcePlugin(
 *   id = "string",
 *   label = @Translation("String"),
 *   description = @Translation("Source handler for 'string' strings."),
 *   ui = "Drupal\string_tmgmt\StringSourcePluginUi"
 * )
 */
class StringSource extends LocaleSource {
  use StringTranslationTrait;

  /**
   * {@inheritdoc}
   */
  public function getItemTypes() {
    return ['default' => $this->t('String')];
  }

  /**
   * {@inheritdoc}
   */
  public function getData(JobItemInterface $job_item): array {
    $structure = parent::getData($job_item);
    if ($string_id = $structure['singular']['#text'] ?? '') {
      $structure['singular']['#label'] = \Drupal::service('string_translator.string.defaults')->getStringTranslation('en', $string_id, '');
    }
    return $structure;
  }

}
