<?php

namespace Drupal\string\Hook;

use Drupal\Core\Hook\Attribute\Hook;

/**
 * Hook implementations for string.
 */
class StringHooks {

  /**
   * Implements hook_themes_installed().
   */
  #[Hook('themes_installed')]
  public function themesInstalled($theme_list): void {
    \Drupal::service('plugin.manager.string')->clearCachedDefinitions();
  }

  /**
   * Implements hook_themes_uninstalled().
   */
  #[Hook('themes_uninstalled')]
  public function themesUninstalled($theme_list): void {
    \Drupal::service('plugin.manager.string')->clearCachedDefinitions();
  }

}
