<?php

namespace Drupal\Tests\string\Functional;

use Drupal\Component\Plugin\Exception\PluginException;
use Drupal\Tests\BrowserTestBase;
use Drupal\string\StringManager;

/**
 * Tests the string admin interface.
 *
 * @group string
 */
class StringAdminTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'system',
    'string',
    'string_demo_test',
    'locale',
    'language',
  ];

  /**
   * The default theme to use for testing.
   *
   * @var string
   */
  protected $defaultTheme = 'claro';

  /**
   * The string manager.
   *
   * @var \Drupal\string\StringManager
   */
  protected $stringManager;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    // Create and log in an admin user.
    $admin_user = $this->drupalCreateUser([
      'manage string export',
      'manage string settings',
    ]);
    $this->drupalLogin($admin_user);

    // Initialize the string manager.
    $this->stringManager = \Drupal::service('plugin.manager.string');
  }

  /**
   * Tests the string export form.
   *
   * NOTE: Disabled this test because it's getting error 500.
   */
  public function disabledTestStringExportForm(): void {
    $this->drupalGet('admin/config/regional/translate/string-export');
    $this->assertSession()->statusCodeEquals(200);

    // First check the export checkbox and submit the form.
    $edit = [
      'show_export' => TRUE,
      'destination' => 'public://string.pot',
    ];
    $this->submitForm($edit, 'Export');
    // @todo Find out why we get error 500 here and fix it.
    $this->assertSession()->statusCodeEquals(200);
    $this->assertSession()->statusMessageExists('status');
    $this->assertSession()->statusMessageContainsAfterWait('The translate items has been exported to', 'status');
  }

  /**
   * Tests the string demo test module.
   */
  public function testStringDemoModule(): void {
    // Verify the module is installed.
    $this->assertTrue(\Drupal::moduleHandler()->moduleExists('string_demo_test'));

    // Check if the string definitions are loaded.
    $definitions = $this->stringManager->getDefinitions();
    $this->assertNotEmpty($definitions);
    $this->assertArrayHasKey('string_demo_test.dashboard.welcome_message.short', $definitions);
  }

  /**
   * Tests the checkForNamespace method.
   */
  public function testCheckForNamespace(): void {
    $reflection = new \ReflectionClass(StringManager::class);
    $method = $reflection->getMethod('checkForNamespace');
    $method->setAccessible(TRUE);

    // Test valid namespace.
    $this->assertNull($method->invoke($this->stringManager, 'valid.namespace'));

    // Test invalid namespace.
    $this->expectException(PluginException::class);
    $method->invoke($this->stringManager, 'invalid namespace');
  }

}
