# Changelog

## 4.0.0 - 2025-10-13

### Added
- Drupal 11 compatibility (core_version_requirement: ^11)
- Exception handling for webhook processing with HTTP 503 retry logic
- #config_target attributes for Key module integration in admin form

### Changed
- **BREAKING CHANGE**: Webhook endpoint now returns HTTP 503 (Service Unavailable) with Retry-After header for RuntimeException failures, instead of HTTP 200. This enables Stripe to automatically retry temporary failures like lock contention.
  - Previous behavior: All webhook processing returned HTTP 200 regardless of outcome
  - New behavior: RuntimeException returns HTTP 503, triggering Stripe's retry mechanism
  - Impact: Monitoring systems watching for HTTP 503 responses will see new status codes for temporary failures
  - Migration: Update any monitoring or logging that expects HTTP 200 for all webhook responses

### Technical Details
- RuntimeException during webhook event dispatching is now caught and logged as a warning
- Stripe's webhook retry system will automatically retry failed requests after 5 seconds
- This improves reliability for transient failures (database locks, temporary service unavailability, etc.)
