<?php

namespace Drupal\Tests\stripe_api\Kernel;

use Drupal\KernelTests\KernelTestBase;
use Drupal\stripe_api\StripeApiService;

/**
 * Test that the service can be constructed.
 *
 * @group stripe_api
 */
class ServiceConstructorTest extends KernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'stripe_api',
    'key',
  ];

  /**
   * Test that the service can be constructed.
   */
  public function testServiceConstructed() {
    // This will make sure we actually have a schema for our config.
    $this->installConfig(static::$modules);
    $service = $this->container->get('stripe_api.stripe_api');
    self::assertInstanceOf(StripeApiService::class, $service);
  }

}
