<?php

namespace Drupal\stripe_api\Event;

use Stripe\Event;

/**
 * Class StripeApiWebhookEvent.
 *
 * Provides the Stripe API Webhook Event.
 */
class StripeApiWebhookEvent extends \Symfony\Contracts\EventDispatcher\Event {

  /**
   * Webhook event type.
   *
   * @var string
   */
  public $type;

  /**
   * Stripe event object.
   *
   * @var \Stripe\Event
   */
  public $event;

  /**
   * Sets the default values for the event.
   *
   * @param string $type
   *   Webhook event type.
   * @param \Stripe\Event|null $event
   *   Stripe event object.
   */
  public function __construct(string $type, ?Event $event = NULL) {
    $this->type = $type;
    $this->event = $event;
  }

}
