<?php

/**
 * @file
 * Rector config.
 */

declare(strict_types=1);

use DrupalRector\Set\Drupal10SetList;
use DrupalRector\Set\Drupal8SetList;
use DrupalRector\Set\Drupal9SetList;
use Rector\Config\RectorConfig;

if (!(is_dir(__DIR__ . '/vendor/drupal/sites'))) {
  mkdir(__DIR__ . '/vendor/drupal/sites');
}

return RectorConfig::configure()
  ->withParallel()
  ->withSets([
    Drupal8SetList::DRUPAL_8,
    Drupal9SetList::DRUPAL_9,
    Drupal10SetList::DRUPAL_10,
  ])
  ->withPaths([__DIR__])
  ->withSkip(['vendor/'])
  ->withFileExtensions(['php', 'module', 'theme', 'install', 'profile', 'inc', 'engine'])
  ->withImportNames(TRUE, FALSE, FALSE);
