<?php

namespace Drupal\subentity\Drush\Generators;

use DrupalCodeGenerator\Asset\AssetCollection;
use DrupalCodeGenerator\Attribute\Generator;
use DrupalCodeGenerator\Command\BaseGenerator;
use DrupalCodeGenerator\GeneratorType;
use DrupalCodeGenerator\Utils;

/**
 * A generator for a subentity.
 */
#[Generator(
  name: 'entity:subentity',
  description: 'Generates a subentity',
  aliases: ['subentity'],
  templatePath: __DIR__ . '/../../../templates/',
  type: GeneratorType::MODULE_COMPONENT,
)]
final class SubEntityGenerator extends BaseGenerator {

  /**
   * {@inheritdoc}
   */
  protected function generate(array &$vars, AssetCollection $assets): void {
    $interviewer = $this->createInterviewer($vars);

    $vars['machine_name'] = $interviewer->askMachineName();
    $vars['name'] = $interviewer->askName();

    $vars['label'] = $interviewer->ask('Entity label', '{name}');
    $vars['entity_class'] = $interviewer->ask('Class name', '{label|camelize}');
    $vars['bundle'] = $interviewer->confirm('Has bundle?', FALSE);
    $vars['entity_name'] = Utils::human2machine($vars['entity_class']);

    $assets->addFile(
      'src/Entity/{entity_class}.php',
      'generator/subentity.php.twig'
    );

    $assets->addFile(
      '{machine_name}.links.menu.yml',
      'generator/links.menu.yml.twig'
    )->prependIfExists();

    $assets->addFile(
      '{machine_name}.links.task.yml',
      'generator/links.task.yml.twig'
    )->prependIfExists();

    $assets->addFile(
      '{machine_name}.routing.yml',
      'generator/routing.yml.twig'
    )->prependIfExists();

    if ($vars['bundle']) {
      $assets->addFile(
        'src/Entity/{entity_class}Type.php',
        'generator/subentity_type.php.twig'
      );

      $assets->addFile(
        'config/schema/{entity_name}_type.yml',
        'generator/subentity_type.schema.yml.twig'
      );

      $assets->addFile(
        '{machine_name}.links.action.yml',
        'generator/links.action.yml.twig'
      );
    }
  }

}
