<?php

namespace Drupal\sucuri_cache;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Logger\LoggerChannelFactoryInterface;
use Drupal\sucuri_cache\Form\SettingsForm;

/**
 * Sucuri Cache module Manager class.
 */
class SucuriCacheManager {

  /**
   * Module settings object.
   *
   * @var \Drupal\Core\Config\ImmutableConfig
   */
  protected $config;

  /**
   * Logger service object.
   *
   * @var \Psr\Log\LoggerInterface
   */
  protected $logger;

  /**
   * Class constructor.
   */
  public function __construct(
    ConfigFactoryInterface $config_factory,
    LoggerChannelFactoryInterface $logger_factory,
  ) {
    $this->config = $config_factory->get(SettingsForm::SETTINGS);
    $this->logger = $logger_factory->get('sucuri_cache');
  }

  /**
   * Gets module settings.
   *
   * @return array
   *   Return array.
   */
  public function getApiCredentials() {
    return [
      'api_endpoint' => $this->config->get('api_endpoint'),
      'api_key' => $this->config->get('api_key'),
      'api_secret' => $this->config->get('api_secret'),
    ];
  }

  /**
   * Logs message in watchdog.
   *
   * @param string $message
   *   Message to log in watchdog.
   * @param array $context
   *   Context of Message.
   *
   * @return void
   *   Returns void.
   */
  public function logError(string $message, array $context = []): void {
    $this->logger->error($message, $context);
  }

}
