<?php

namespace Drupal\sucuri_cache\Access;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Routing\Access\AccessInterface;
use Drupal\Core\Session\AccountInterface;

/**
 * Determines access to Sucuri cache actions.
 */
class PurgeCacheAccessCheck implements AccessInterface {

  /**
   * Checks access for renaming file.
   *
   * @param \Drupal\Core\Session\AccountInterface $account
   *   The currently logged in account.
   * @param \Drupal\Core\Entity\EntityInterface $node
   *   The node to check access for.
   *
   * @return \Drupal\Core\Access\AccessResultInterface
   *   The access result.
   */
  public function access(AccountInterface $account, EntityInterface $node) {
    // @todo delete this access check?
    // @todo check entity access?
    return AccessResult::allowedIf(
      $account->hasPermission('purge sucuri cache all')
    );
  }

}
