<?php

namespace Drupal\sucuri_cache\Form;

use Drupal\Core\DependencyInjection\ContainerInjectionInterface;
use Drupal\Core\Form\ConfirmFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;
use Drupal\sucuri_cache\SucuriCachePurger;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Clears sucuri caches for the site.
 *
 * @internal
 */
class PurgeAllCachesForm extends ConfirmFormBase implements ContainerInjectionInterface {

  /**
   * The Sucuri cache purger service.
   *
   * @var \Drupal\sucuri_cache\SucuriCachePurger
   */
  protected $sucuriCachePurger;

  /**
   * Constructs a new PurgeAllCachesForm.
   *
   * @param \Drupal\sucuri_cache\SucuriCachePurger $sucuri_cache_purger
   *   The Sucuri cache purger service.
   */
  public function __construct(SucuriCachePurger $sucuri_cache_purger) {
    $this->sucuriCachePurger = $sucuri_cache_purger;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('sucuri_cache.purger')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'sucuri_cache__purge_all_caches';
  }

  /**
   * Clears the caches.
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $result = $this->sucuriCachePurger->purgeAllCache();
    
    if ($result) {
      $this->messenger()->addStatus($this->t('Sucuri cache cleared successfully for all pages.'));
    }
    else {
      $this->messenger()->addError($this->t('Failed to clear Sucuri cache for all pages. Please check the logs for more details.'));
    }
    
    // Redirect to admin content page.
    $form_state->setRedirect('system.admin_content');
  }

  /**
   * Confirmation question.
   */
  public function getQuestion() {
    return $this->t('Do you want to purge Sucuri caches for ALL site pages?');
  }

  /**
   * URL Redirect.
   */
  public function getCancelUrl() {
    return new Url('<front>');
    // @todo redirect back.
  }

}
