# Sudoku

Provides a Sudoku puzzle editor, generator, and solver within Drupal.

This module allows site administrators to create, edit, and solve Sudoku puzzles
through an interactive form that supports AJAX generation and persistent
storage.

---

## Table of contents

- [Requirements](#requirements)
- [Installation](#installation)
- [Configuration](#configuration)
- [Usage](#usage)
- [Permissions](#permissions)
- [Development Notes](#development-notes)
- [Troubleshooting](#troubleshooting)
- [Maintainers](#maintainers)
- [License](#license)

---

## Requirements

- Drupal 10 or later
- PHP 8.1 or later
- Database: MySQL/MariaDB, PostgreSQL, or SQLite (standard Drupal support)

No external libraries are required.

---

## Installation

1. Place the module in your Drupal installation at `modules/custom/sudoku`.
2. Enable it using the **Extend** page (`/admin/modules`) or with Drush:
```bash
drush en sudoku
drush cr
```
3. After enabling, a new Sudoku section appears under `/admin/content/sudoku`.

---

## Configuration

No special configuration is required beyond enabling the module. Optional
settings are available under: `/admin/config/content/sudoku`. These may include
difficulty presets and grid size options if implemented.

---

## Usage

1. Navigate to `/admin/content/sudoku/add` to create a new Sudoku puzzle.
2. The form provides:
    * A **Generate** button to auto-fill a random puzzle via AJAX.
    * Editable input fields representing each Sudoku cell.
    * A **Save** button to store puzzle data in the database.
3. When saving, the module serializes the grid structure and saves it to the
entity storage, making puzzles editable and reloadable.
4. Puzzles can be listed, viewed, and edited through standard Drupal entity
interfaces.

---

## Permissions

The following permissions are provided (if implemented):

<table>
  <thead>
    <tr>
      <th>Permission</th>
      <th>Description</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>administer sudoku puzzles</code></td>
      <td>Create, edit, delete, and manage all Sudoku puzzles.</td>
    </tr>
    <tr>
      <td><code>edit own sudoku puzzles</code></td>
      <td>Edit only puzzles created by the current user.</td>
    </tr>
    <tr>
      <td><code>view sudoku puzzles</code></td>
      <td>View existing puzzles.</td>
    </tr>
  </tbody>
</table>

To grant permissions, go to: `/admin/people/permissions`.

## Development Notes

* **Entity Type:** The module defines a custom `sudoku` content entity type to
store puzzles and metadata.
* **Form:** `SudokuForm` extends `ContentEntityForm` to manage puzzle editing,
including AJAX generation and validation.
* **AJAX Callbacks:** The Generate button triggers `/sudoku/ajax/generate`,
which produces a random puzzle server-side.
* **Services:** The module includes a `sudoku.solver` service responsible for
puzzle generation and solving.
* **Logging:** All internal debug and error messages are routed through the
injected logger service (`logger.factory` → `sudoku` channel), conforming to
Drupal’s dependency injection best practices.
* **Front-end assets:** JavaScript (`sudoku_admin.js`) handles AJAX behaviors
for puzzle generation and form updates.

---

## Troubleshooting

<table>
  <thead>
    <tr>
      <td>Issue</td>
      <td>Possible Cause</td>
      <td>Solution</td>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td>"Generate" button not responding</td>
      <td>JavaScript not loaded or AJAX path misconfigured</td>
      <td>Check browser console and verify that `sudoku_admin.js` is
          loaded.</td>
    </tr>
    <tr>
      <td>Changes to puzzles not saving</td>
      <td>Grid input fields not named correctly</td>
      <td>Ensure all <code>&lt;input&gt;</code> elements use
          <code>name="grid[row][col]"</code> format.</td>
    </tr>
    <tr>
      <td>403 or CSRF errors on AJAX requests</td>
      <td>Form token mismatch</td>
      <td>Clear Drupal caches (<code>drush cr</code>) and reload the form.</td>
    </tr>
  </tbody>
</table>

---

## Maintainers

* **Richard Brum** [[@TerranRich](https://www.drupal.org/u/terranrich)]<br>
  Drupal developer<br>
  *Atlanta, GA, USA*

---

## License

This project is distributed under the terms of the
[GNU General Public License, v3](https://www.gnu.org/licenses/gpl-3.0.html).
