(function (Drupal, drupalSettings, once) {

  Drupal.behaviors.sudokuAdmin = {
    attach: function (context) {
      // Attach generate button behavior once.
      for (const button of once('sudoku-generate', '.sudoku-generate', context)) {
        // Debug: confirm handler attached.
        console.log('sudoku: attach generate handler to', button);
        button.addEventListener('click', (e) => {
          e.preventDefault();
          // Try id then name as fallback.
          const difficultyEl = document.querySelector('#edit-difficulty')
            || document.querySelector('select[name="generate_random"]');
          const difficulty = (difficultyEl && difficultyEl.value)
            ? difficultyEl.value : 'medium';
          console.log('sudoku: generate clicked, difficulty=', difficulty);

          fetch(Drupal.url('sudoku/ajax/generate'), {
            method: 'POST',
            headers: {
              'Content-Type': 'application/json',
              'X-Requested-With': 'XMLHttpRequest',
            },
            body: JSON.stringify({ difficulty }),
          })
            .then((r) => {
              if (!r.ok) {
                throw new Error('Server returned ' + r.status);
              }
              return r.json();
            })
            .then((data) => {
              console.log('sudoku: generate response', data);
              // adjust according to your controller shape: check both shapes.
              const puzzle = data?.puzzle?.puzzle ?? data?.puzzle ?? null;
              if (puzzle) {
                fillGrid(puzzle);
              } else if (data?.error) {
                console.error('Generate error:', data.error);
                alert(data.error);
              } else {
                console.warn('Generate: unexpected response', data);
              }
            })
            .catch((err) => {
              console.error('Generate error:', err);
              alert('Generate failed. Check console for details.');
            });
        });
      }

      // Attach solve button behavior once.
      for (const button of once('sudoku-solve', '.sudoku-solve', context)) {
        button.addEventListener('click', (e) => {
          e.preventDefault();
          const grid = getGridValues();
          fetch(Drupal.url('sudoku/ajax/solve'), {
            method: 'POST',
            headers: {
              'Content-Type': 'application/json',
              'X-Requested-With': 'XMLHttpRequest',
            },
            body: JSON.stringify({ puzzle: grid }),
          })
            .then((r) => r.json())
            .then((data) => {
              if (data && data.solution) {
                fillGrid(data.solution);
              }
            })
            .catch((err) => console.error('Solve error:', err));
        });
      }

      /**
       * Helper: read 9×9 grid from text inputs.
       */
      function getGridValues() {
        const grid = [];
        for (let r = 0; r < 9; r++) {
          grid[r] = [];
          for (let c = 0; c < 9; c++) {
            const input = document.querySelector(`#edit-grid-${r}-${c}`);
            grid[r][c] = parseInt(input.value) || 0;
          }
        }
        return grid;
      }

      /**
       * Helper: write 9×9 grid back into text inputs and hidden field.
       */
      function fillGrid(data) {
        if (!Array.isArray(data)) {
          return;
        }
        for (let r = 0; r < 9; r++) {
          for (let c = 0; c < 9; c++) {
            const input = document.querySelector(`#edit-grid-${r}-${c}`);
            if (input) {
              input.value = data[r][c] || '';
            }
          }
        }

        const hidden = document.querySelector('#edit-puzzle-json');
        if (hidden) {
          hidden.value = JSON.stringify(data);
        }
      }
    },
  };

})(Drupal, drupalSettings, once);
