<?php

namespace Drupal\sudoku;

use Drupal\Core\Entity\EntityListBuilder;
use Drupal\Core\Entity\EntityInterface;

/**
 * Defines a class to build a listing of Sudoku entities.
 */
class SudokuListBuilder extends EntityListBuilder {

  /**
   * Build the header row for the table.
   *
   * @return array
   *   The header row.
   */
  public function buildHeader(): array {
    $header['id'] = $this->t('ID');
    $header['title'] = $this->t('Title');
    $header['created'] = $this->t('Created');
    // Add more headers as needed.
    return $header + parent::buildHeader();
  }

  /**
   * Build a row for the given entity.
   *
   * @param \Drupal\Core\Entity\EntityInterface $entity
   *   The entity.
   *
   * @return array
   *   The row data.
   */
  public function buildRow(EntityInterface $entity): array {
    $row['id'] = $entity->id();
    $row['title'] = $entity->label();
    $row['created'] = \Drupal::service('date.formatter')->format(
      $entity->get('created')->value
    );
    return $row + parent::buildRow($entity);
  }

}
