# Supported Image Field

Defines a field type for image media supported by free-form caption and attribution sub-fields.

## Features

 - New **Supported image** field type extends core's **Image** field to include *Caption* and *Attribution* subfields.
 - Just like core's *Title* and *Alt* subfields, these *Caption* and *Attribution* subfields can be toggled on/off and set to required/optional per field instance.
 - Caption and Attribution are free-form, formatted text fields so users can leverage familiar WYSIWYG tools to create, link, and format content. Achieving different attribution formats as different image sources and licenses may require becomes simple (e.g. "Photo by [Author](#) on [Source](#)" vs "[Source.com/Author](#)" vs "'[Title](#)' by [Author](#) is licensed under [License](#)").
    - Allowed text formats is also configurable. This gives you control over what your users can enter into these sub-fields (for example, you could restrict entry to only simple formatting like bold/italic + links).
 - Default image support: *Caption* and *Attribution* content can be configured in the field instance's default image (storage or field-instance level).
 - Default output uses semantic [`<figure>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Reference/Elements/figure) and [`<figcaption>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Reference/Elements/figcaption) elements (default twig template can be overridden if necessary).
 - Basic [Views](https://www.drupal.org/documentation/modules/views) support.
 - [Responsive Image](https://www.drupal.org/documentation/modules/responsive_image) support via included **Responsive Supported Image Formatter** sub-module.
 - [Image Delta Formatter](https://www.drupal.org/project/image_delta_formatter) support via [Supported Image Delta Formatter](https://www.drupal.org/project/supported_image_delta_formatter) module (includes **Responsive Supported Image Delta Formatter** sub-module).
 - [baguetteBox.js](https://www.drupal.org/project/baguettebox) support via [Supported Image BaguetteBox Formatter](https://www.drupal.org/project/supported_image_baguettebox) module.
 - Basic test coverage.
 - Leaves the core image field type and field formatters unaltered (builds on them instead of altering them).

## Post-installation

Add and configure a new *Supported image* field onto a fieldable entity, then configure the field's display through one of the available field formatters.

## Additional requirements

None.

## Similar projects

 - Drupal core's [Media](https://www.drupal.org/docs/8/core/modules/media) module
    - Introduces a re-usable media entity where an image (or supported image) field can be added, along with other fields
    - Large contrib ecosystem
    - Can add some complexity to authoring permissions (e.g. can user B modify user A's image?)
    - Unused media may need manual cleanup
    - Can add complexity to content migrations when compared to migrating into a simple Image or Supported image field
    - This module is compatible with media, and could be a way of bringing caption and/or attribution into an image media type
 - [Rich Image](https://www.drupal.org/project/rich_image)
    - Extends/alters the core image field to add a variety of sub-fields (unaltered core image field is no longer available)
    - Sub-fields collected in a new "Rich image properties" fieldset
    - Attribution is a plain-text one-liner, so link inclusion might be harder for less technical users
    - Caption seems to be a formatted textarea
    - Non-configurable help text for caption, attribution, and other subfields
    - It appears that the default image's attribution line can be set, but not the caption content
    - Small user base, no supported releases, and no test coverage (as of 2025-10)
 - [Image Field Caption](https://www.drupal.org/project/image_field_caption)
    - Extends/alters the core image field to introduce a formatted caption textarea (unaltered core image field is no longer available)
    - No attribution handling
    - Non-configurable help text for caption

## Supporting this module

You can support this module by helping out in [our issue queue](https://www.drupal.org/project/issues/supported_image). Report bugs, feature requests, or other issues, and propose resolutions via merge requests or patches.
