<?php

namespace Drupal\responsive_supported_image_formatter\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\Attribute\FieldFormatter;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\responsive_image\Plugin\Field\FieldFormatter\ResponsiveImageFormatter;
use Drupal\supported_image\Plugin\Field\FieldFormatter\SupportedImageFormatterTrait;
use Drupal\supported_image\Plugin\Field\FieldType\SupportedImageItem;

/**
 * Plugin implementation of the 'responsive_supported_image' formatter.
 */
#[FieldFormatter(
  id: 'responsive_supported_image',
  label: new TranslatableMarkup('Responsive image'),
  description: new TranslatableMarkup('Display a supported image field through a responsive image style.'),
  field_types: [
    'supported_image',
  ],
)]
class ResponsiveSupportedImageFormatter extends ResponsiveImageFormatter {

  use SupportedImageFormatterTrait {
    viewElements as SupportedImageFormatterTraitViewElements;
  }

  /**
   * {@inheritdoc}
   */
  protected function getItemRenderThemeHook(): string {
    return 'responsive_supported_image_formatter';
  }

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode): array {
    $elements = $this->SupportedImageFormatterTraitViewElements($items, $langcode);

    // Parent incorrectly assigns a string for the url variable when the
    // link to file option is chosen. Remove this once the parent is fixed.
    // @see https://www.drupal.org/project/drupal/issues/3064751
    if ($this->getSetting('image_link') === 'file') {
      foreach ($items as $delta => $item) {
        if (isset($elements[$delta]['#item']) && $elements[$delta]['#item'] instanceof SupportedImageItem) {
          // @phpstan-ignore-next-line
          $elements[$delta]['#url'] = \Drupal::service('file_url_generator')
            ->generate($elements[$delta]['#item']->entity->getFileUri());
        }
      }
    }

    return $elements;
  }

}
