<?php

namespace Drupal\supported_image;

use Drupal\Core\TypedData\Plugin\DataType\BooleanData;
use Drupal\field\FieldConfigInterface;

/**
 * Computed 'is_default_value' property on supported_image field items.
 *
 * Determines whether the item is the field default (display) item.
 */
class ItemIsDefaultValue extends BooleanData {

  /**
   * {@inheritdoc}
   */
  public function getValue() {
    /** @var \Drupal\Core\Field\FieldItemInterface $item */
    $item = $this->getParent();

    $default_image = $item->getFieldDefinition()->getSetting('default_image');
    // If we are dealing with a configurable field, look in both instance-level
    // and field-level settings.
    if (empty($default_image['uuid']) && $item->getFieldDefinition() instanceof FieldConfigInterface) {
      $default_image = $item
        ->getFieldDefinition()
        ->getFieldStorageDefinition()
        ->getSetting('default_image');
    }

    return !empty($default_image['uuid']) && $default_image['uuid'] === $item->entity->uuid();
  }

}
