<?php

namespace Drupal\supported_image\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\Attribute\FieldFormatter;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\image\Plugin\Field\FieldFormatter\ImageFormatter;

/**
 * Plugin implementation of the 'supported_image' formatter.
 */
#[FieldFormatter(
  id: 'supported_image',
  label: new TranslatableMarkup('Image'),
  description: new TranslatableMarkup('Image with supporting caption and attribution content, if present.'),
  field_types: [
    'supported_image',
  ],
)]
class SupportedImageFormatter extends ImageFormatter {

  use SupportedImageFormatterTrait;

  /**
   * {@inheritdoc}
   */
  protected function getItemRenderThemeHook(): string {
    return 'supported_image_formatter';
  }

}
