<?php

/**
 * @file
 * Implement a supported image field.
 */

/**
 * Prepares variables for supported image formatter templates.
 *
 * Default template: supported-image-formatter.html.twig.
 *
 * @param array $variables
 *   An associative array containing:
 *   - item: An SupportedImageItem object.
 *   - item_attributes: An optional associative array of html attributes to be
 *     placed in the img tag.
 *   - image_style: An optional image style.
 *   - url: An optional \Drupal\Core\Url object.
 *   - display_caption: Boolean indicating we we are to display the caption.
 *   - display_attribution: Boolean indicating we we are to display the
 *     attribution.
 */
function template_preprocess_supported_image_formatter(&$variables) {
  // Run parent preprocessing.
  \Drupal::moduleHandler()->loadInclude('image', 'inc', 'image.field');
  template_preprocess_image_formatter($variables);

  // Attach our library.
  $variables['#attached']['library'][] = 'supported_image/supported_image_formatter';

  // Set up caption and attribution variables.
  $variables['caption'] = NULL;
  if ($variables['display_caption'] && isset($variables['item']->caption_value) && $variables['item']->caption_value !== '') {
    $variables['caption'] = [
      '#type' => 'processed_text',
      '#text' => $variables['item']->caption_value,
      '#format' => $variables['item']->caption_format,
      '#langcode' => $variables['item']->getLangcode(),
    ];
  }
  $variables['attribution'] = NULL;
  if ($variables['display_attribution'] && isset($variables['item']->attribution_value) && $variables['item']->attribution_value !== '') {
    $variables['attribution'] = [
      '#type' => 'processed_text',
      '#text' => $variables['item']->attribution_value,
      '#format' => $variables['item']->attribution_format,
      '#langcode' => $variables['item']->getLangcode(),
    ];
  }
}
