<?php

/**
 * @file
 * Views hooks for the supported image module.
 */

use Drupal\field\FieldStorageConfigInterface;

/**
 * Implements hook_field_views_data().
 *
 * Views integration for supported_image fields. Adds an image relationship
 * to the default field data.
 *
 * @see views_field_default_views_data()
 */
function supported_image_field_views_data(FieldStorageConfigInterface $field_storage) {
  return \Drupal::moduleHandler()
    ->invoke('image', 'field_views_data', [$field_storage]);
}

/**
 * Implements hook_field_views_data_views_data_alter().
 *
 * Views integration to provide reverse relationships on supported_image
 * fields.
 */
function supported_image_field_views_data_views_data_alter(array &$data, FieldStorageConfigInterface $field_storage) {
  \Drupal::moduleHandler()
    ->invoke('image', 'field_views_data_views_data_alter', [&$data, $field_storage]);
}
