<?php

declare(strict_types=1);

namespace Drupal\Tests\supported_image\Kernel\Views;

use Drupal\field\Entity\FieldConfig;
use Drupal\Tests\image\Kernel\Views\RelationshipUserImageDataTest;
use Drupal\Tests\views\Kernel\ViewsKernelTestBase;
use Drupal\views\Tests\ViewTestData;
use Drupal\field\Entity\FieldStorageConfig;

/**
 * Tests supported_image on user relationship handler.
 *
 * Adapted from Drupal\Tests\image\Kernel\Views\RelationshipUserImageDataTest.
 *
 * @see \Drupal\Tests\image\Kernel\Views\RelationshipUserImageDataTest
 * @group supported_image
 */
class RelationshipUserSupportedImageDataTest extends RelationshipUserImageDataTest {

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['filter', 'text', 'supported_image'];

  /**
   * {@inheritdoc}
   */
  protected function setUp($import_test_views = TRUE): void {
    ViewsKernelTestBase::setUp($import_test_views);

    $this->installEntitySchema('file');
    $this->installSchema('file', ['file_usage']);
    $this->installEntitySchema('user');

    // Create the user profile field and instance.
    FieldStorageConfig::create([
      'entity_type' => 'user',
      'field_name' => 'user_picture',
      'type' => 'supported_image',
      'translatable' => '0',
    ])->save();
    FieldConfig::create([
      'label' => 'User Picture',
      'description' => '',
      'field_name' => 'user_picture',
      'entity_type' => 'user',
      'bundle' => 'user',
      'required' => 0,
    ])->save();

    ViewTestData::createTestViews('Drupal\Tests\image\Kernel\Views\RelationshipUserImageDataTest', ['image_test_views']);
  }

}
