/**
 * @file
 * supportedImageBaguettebox behavior.
 *
 * Adapted from Drupal.behaviors.baguetteBox from the baguettebox module.
 *
 * @see https://git.drupalcode.org/project/baguettebox/-/blob/3.0.x/js/baguettebox.js
 */

((Drupal, baguetteBox) => {
  Drupal.behaviors.supportedImageBaguettebox = {
    attach: function attach(context, settings) {
      const bbSettings = settings.baguettebox;
      let captions = false;

      if (bbSettings.captions_source !== 'none') {
        captions = (a) => {
          const image = a.querySelector('img');
          const caption = a.closest('figure').querySelector('.caption');
          const attribution = a.closest('figure').querySelector('.attribution');
          switch (bbSettings.captions_source) {
            case 'image_title':
              return image.getAttribute('title')
                ? Drupal.checkPlain(image.getAttribute('title'))
                : '';
            case 'image_alt':
              return image.getAttribute('alt')
                ? Drupal.checkPlain(image.getAttribute('alt'))
                : '';
            case 'image_caption':
              return caption ? caption.innerHTML : '';
            case 'image_attribution':
              return attribution ? attribution.innerHTML : '';
            case 'image_caption_and_attribution': {
              let output = '';
              if (caption) {
                output += caption.outerHTML;
              }
              if (attribution) {
                output += attribution.outerHTML;
              }
              return output;
            }
            default:
              return '';
          }
        };
      }

      const selector = bbSettings.selector ?? '.baguettebox';

      baguetteBox.run(selector, {
        captions,
        animation: bbSettings.animation,
        buttons: bbSettings.buttons ? 'auto' : false,
        fullScreen: bbSettings.fullscreen,
        noScrollbars: bbSettings.hide_scrollbars,
      });
    },
  };
})(Drupal, window.baguetteBox);
