<?php

/**
 * @file
 * Hooks relating to the supported image baguettebox field formatter.
 */

use Drupal\Core\Template\Attribute;

/**
 * Prepares variables for supported image baguettebox formatter templates.
 *
 * Default template: supported-image-baguettebox-formatter.html.twig.
 *
 * Adapted from template_preprocess_baguettebox_formatter().
 *
 * @param array $variables
 *   An associative array containing:
 *   - item: An SupportedImageItem object.
 *   - item_attributes: An optional associative array of html attributes to be
 *     placed in the img tag.
 *   - link_attributes: An optional associative array of html attributes to be
 *     placed in the a tag.
 *   - image_style: An optional image style.
 *   - url: An optional \Drupal\Core\Url object.
 *   - display_caption: Boolean indicating we we are to display the caption.
 *   - display_attribution: Boolean indicating we we are to display the
 *     attribution.
 *
 * @see template_preprocess_baguettebox_formatter()
 */
function template_preprocess_supported_image_baguettebox_formatter(array &$variables): void {
  // Apply parent preprocessing, keeping caption and attribution on (we hide
  // these visually so that we can pull them up into the lightbox even if they
  // aren't shown initially).
  $display_caption = $variables['display_caption'];
  $display_attribution = $variables['display_attribution'];
  $variables['display_caption'] = TRUE;
  $variables['display_attribution'] = TRUE;
  \Drupal::moduleHandler()
    ->loadInclude('supported_image', 'inc', 'supported_image.field');
  template_preprocess_supported_image_formatter($variables);
  $variables['link_attributes'] = new Attribute($variables['link_attributes']);

  // Revert the display variables to what they were originally so the template
  // can produce the content and visually-hide it outside of the lightbox if
  // necessary.
  $variables['display_caption'] = $display_caption;
  $variables['display_attribution'] = $display_attribution;

  // Remove parent library.
  if ($key = array_search('baguettebox/formatter', $variables['#attached']['library'])) {
    unset($variables['#attached']['library'][$key]);
  }

  // Attach our library.
  $variables['#attached']['library'][] = 'supported_image_baguettebox/formatter';
}
