<?php

namespace Drupal\supported_image_baguettebox\Plugin\Field\FieldFormatter;

use Drupal\baguettebox\Plugin\Field\FieldFormatter\BaguetteboxFormatter;
use Drupal\Core\Field\Attribute\FieldFormatter;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\supported_image\Plugin\Field\FieldFormatter\SupportedImageFormatterTrait;

/**
 * Plugin implementation of the 'supported_image_baguettebox' formatter.
 */
#[FieldFormatter(
  id: 'supported_image_baguettebox',
  label: new TranslatableMarkup('BaguetteBox'),
  description: new TranslatableMarkup('Image with baguetteBox.js integration.'),
  field_types: [
    'supported_image',
  ],
)]
class SupportedImageBaguetteboxFormatter extends BaguetteboxFormatter {

  use SupportedImageFormatterTrait;

  /**
   * {@inheritdoc}
   */
  protected function getItemRenderThemeHook(): string {
    return 'supported_image_baguettebox_formatter';
  }

  /**
   * {@inheritdoc}
   */
  protected function captionsSourceOptions(): array {
    return parent::captionsSourceOptions() + [
      'image_caption' => $this->t('Image caption'),
      'image_attribution' => $this->t('Image attribution'),
      'image_caption_and_attribution' => $this->t('Image caption and attribution'),
    ];
  }

}
