<?php

namespace Drupal\responsive_supported_image_delta_formatter\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\Attribute\FieldFormatter;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\image_delta_formatter\Plugin\Field\FieldFormatter\ImageDeltaTrait;
use Drupal\responsive_supported_image_formatter\Plugin\Field\FieldFormatter\ResponsiveSupportedImageFormatter;

/**
 * Plugin implementation of the 'responsive_supported_image_delta' formatter.
 */
#[FieldFormatter(
  id: 'responsive_supported_image_delta',
  label: new TranslatableMarkup('Responsive image delta'),
  description: new TranslatableMarkup('Display specific deltas of a supported image field through a responsive image style.'),
  field_types: [
    'supported_image',
  ],
)]
class ResponsiveSupportedImageDeltaFormatter extends ResponsiveSupportedImageFormatter {

  use ImageDeltaTrait;

}
