<?php

namespace Drupal\supported_image_delta_formatter\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\Attribute\FieldFormatter;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\image_delta_formatter\Plugin\Field\FieldFormatter\ImageDeltaTrait;
use Drupal\supported_image\Plugin\Field\FieldFormatter\SupportedImageFormatter;

/**
 * Plugin implementation of the 'supported_image_delta' formatter.
 */
#[FieldFormatter(
  id: 'supported_image_delta',
  label: new TranslatableMarkup('Image delta'),
  description: new TranslatableMarkup('Display specific deltas of a supported image field.'),
  field_types: [
    'supported_image',
  ],
)]
class SupportedImageDeltaFormatter extends SupportedImageFormatter {

  use ImageDeltaTrait;

}
