# Drupal Surge

A simple, focused coding standards system for Drupal development.

## Installation

```bash
composer require drupal/surge
```

## Automatic Setup ✨

When you install this package, the Surge commands are automatically available through Composer scripts. The package includes a Composer plugin that automatically registers the necessary scripts in your project's `composer.json`.

**Note**: You may need to allow the plugin to run by executing:
```bash
composer config allow-plugins.drupal/surge true
```

## Usage

After installation, you can use Surge directly:

```bash
composer surge-standards
composer surge-scan
```

## Commands

- `composer surge-standards` - Interactively helps you apply Drupal coding standards to your preferred IDE/Tool
- `composer surge-scan` - Scan project for community-contributed guidelines and merges them in an `AGENTS-with-community.md` file, this allows users to keep in the loop with what guidelines are generated and copy it to the right place themselves.

## AI Agent Support 🤖

### AGENTS.md format
Follows the emerging [AGENTS.md standard](https://agents.md/) used by 20k+ open-source projects

Creates a single `AGENTS.md` file that works across the ecosystem:
- **Cursor** - Modern AI-powered code editor
- **Claude** - Anthropic's AI assistant
- **Codex** - OpenAI's code generation model
- **Amp, Jules, Factory, RooCode** - And 10+ other modern agents

### IDE-Specific Support
Creates IDE-specific files and configurations for tools that need them:
- **Junie (PhpStorm)** - `.junie/guidelines.md`
- **Claude Code** - `Claude.md`
- **Aider** - `.aider.conf.yml` configuration (uses Agents.md, but configures it)
- **Gemini CLI** - `.gemini/settings.json` configuration (uses Agents.md, but configures it)
- **Custom** - Outputs guidelines to CLI for copy-paste to unsupported tools

### Why Both Approaches?

The AI coding agent ecosystem is rapidly evolving. While the [AGENTS.md standard](https://agents.md/) is gaining adoption, many tools haven't implemented it yet and still require their own specific formats.
