<?php

namespace Drupal\Surge\Console;

use Symfony\Component\Console\Application;
use Symfony\Component\Console\Input\ArrayInput;
use Symfony\Component\Console\Output\ConsoleOutput;
use Drupal\Surge\Console\Command\StandardsCommand;
use Drupal\Surge\Console\Command\ScanGuidelinesCommand;

class SurgeApplication extends Application
{
    public function __construct()
    {
        parent::__construct('Drupal Surge', '1.0.0');
        
        $this->add(new StandardsCommand());
        $this->add(new ScanGuidelinesCommand());
    }

    /**
     * Static method to run the standards command
     * Called directly from Composer scripts
     */
    public static function runStandards()
    {
        $app = new self();
        $input = new ArrayInput(['standards']);
        $output = new ConsoleOutput();
        
        return $app->run($input, $output);
    }

    /**
     * Static method to run the scan-guidelines command
     * Called directly from Composer scripts
     */
    public static function runScan()
    {
        $app = new self();
        $input = new ArrayInput(['scan-guidelines']);
        $output = new ConsoleOutput();
        
        return $app->run($input, $output);
    }
}
