# Community Guidelines Feature

## Overview

Drupal Surge now includes an automatic community guidelines detection and merging system. This allows package authors and project teams to contribute their own coding standards and best practices that get automatically incorporated into the main standards.

## How It Works

### 1. Directory Structure

Community guidelines are stored in `surge-guidelines/*` directories throughout your project structure:

```
your-project-root/
├── surge-guidelines/                    # Main project guidelines
│   ├── project-standards.md
│   ├── security-standards.md
│   └── testing-standards.md
├── modules/custom/your-module/
│   └── surge-guidelines/                # Module-specific guidelines
│       └── module-standards.md
├── themes/custom/your-theme/
│   └── surge-guidelines/                # Theme-specific guidelines
│       └── theme-standards.md
└── composer.json
```

### 2. Automatic Detection

When you run `php surge scan-guidelines`, the system:

- Scans the current project's `surge-guidelines/` directory
- **Recursively scans all project subdirectories** for additional `surge-guidelines/` folders
- Automatically merges all found guidelines with the base standards
- Creates a comprehensive `drupal-surge-standards-with-community.md` file

### 3. Smart Merging

The system intelligently merges guidelines by:

- Preserving the original base standards
- Adding community guidelines with clear attribution
- Organizing guidelines by source (Main Guidelines, Module Name, Theme Name, etc.)
- Maintaining proper markdown formatting and structure

### 4. Recursive Scanning

The system automatically discovers guidelines throughout your project structure:

**How It Works:**
1. **Root Level**: Starts with the main `surge-guidelines/` directory
2. **Directory Discovery**: Identifies all project subdirectories (excluding vendor, .git, etc.)
3. **Recursive Search**: Walks through each subdirectory looking for `surge-guidelines/` folders
4. **Guideline Collection**: Gathers all `.md` files from discovered guidelines directories
5. **Smart Organization**: Groups guidelines by their location in the project structure

**What Gets Scanned:**
- ✅ Project root: `surge-guidelines/`
- ✅ Module directories: `modules/custom/your-module/surge-guidelines/`
- ✅ Theme directories: `themes/custom/your-theme/surge-guidelines/`
- ✅ Any other project subdirectory with `surge-guidelines/`

**What Gets Excluded:**
- ❌ `vendor/` (Composer dependencies)
- ❌ `.git/` (Version control)
- ❌ `node_modules/` (Node.js dependencies)

## Usage

### Scanning for Guidelines

```bash
# Basic scan and merge
php surge scan-guidelines

# Preview what would be merged (dry run)
php surge scan-guidelines --dry-run

# Specify custom output file
php surge scan-guidelines --output custom-standards.md
```

### Using Merged Guidelines

The standards command automatically detects and uses merged guidelines:

```bash
php surge standards
```
