/* eslint-disable import/no-unresolved */
/**
 * @file defines InsertSvgSpriteCommand, which is executed when the svgSprite
 * toolbar button is pressed.
 */
import { Command } from 'ckeditor5/src/core';

function cleanClass(name) {
  return name.replace(/[!"#$%&'()*+,./:;<=>?@[\\\]^`{|}~]/g, '-');
}

function createSvgSprite(writer, attributes, config) {
  // Create instances of the three elements registered with the editor in
  // svg_sprite-editing.js.
  const svgSprite = writer.createElement('svgSprite');

  // Get our data from user input to pass to our elements.
  const spriteId = cleanClass(attributes.name);

  // Add <use> classes from the contexual menu.
  writer.setAttribute('sprite_id', `${spriteId}`, svgSprite);

  // Return the element to be added to the editor.
  return svgSprite;
}

export default class InsertSvgSpriteCommand extends Command {
  /**
   * @inheritdoc
   */
  execute(attributes) {
    const { model } = this.editor;

    const config = this.editor.config.get('svgSprite');

    model.change((writer) => {
      // Insert <svgSprite></svgSprite> at the current selection position
      // in a way that will result in creating a valid model structure.
      model.insertContent(createSvgSprite(writer, attributes, config));
    });
  }

  /**
   * @inheritdoc
   */
  refresh() {
    const { model } = this.editor;
    const { selection } = model.document;

    // Determine if the cursor (selection) is in a position where adding a
    // svgSprite is permitted. This is based on the schema of the model(s)
    // currently containing the cursor.
    const allowedIn = model.schema.findAllowedParent(
      selection.getFirstPosition(),
      'svgSprite',
    );

    // If the cursor is not in a location where a svgSprite can be added, return
    // null so the addition doesn't happen.
    this.isEnabled = allowedIn !== null;
  }
}
