<?php

namespace Drupal\svg_sprite\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\Attribute\FieldFormatter;
use Drupal\Core\Field\FieldItemInterface;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\FormatterBase;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\svg_sprite\SvgSpriteHelper;

/**
 * Plugin implementation of the 'svg_sprite' formatter.
 */
#[FieldFormatter(
  id: 'svg_sprite',
  label: new TranslatableMarkup('SVG Sprite'),
  field_types: [
    'svg_sprite',
  ],
)]
class SvgSpriteFormatter extends FormatterBase {

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode) {
    $elements = [];
    foreach ($items as $delta => $item) {
      $view_value = $this->viewValue($item);
      $elements[$delta] = $view_value;
    }
    return $elements;
  }

  /**
   * Generate the output appropriate for one field item.
   *
   * @param \Drupal\Core\Field\FieldItemInterface $item
   *   One field item.
   *
   * @return array
   *   The textual output generated as a render array.
   */
  protected function viewValue(FieldItemInterface $item) {
    $sprite_id = $item->value;
    return SvgSpriteHelper::buildSvgSpriteRenderArray($sprite_id);
  }

}
