# SVG Sprite

This module adds a new field type called SVG Sprite.  Using this field you can
select an icon from a dropdown list which is auto-generated from a SVG Sprite
file.

It reads the SVG Sprite and automatically adds every
`<symbol id="">...</symbol>` to the list, which is typically how SVG
Sprites are generated.

It outputs something similar to `file.svg#symbol-id` using a
dedicated field formatter.

A small Twig extension is also available allowing to easily display an SVG
sprite in your Twig templates: `{{ svg_sprite('lightbulb') }}`.

You can add custom attributes to your sprite Twig function:

```twig
{{ svg_sprite('lightbulb', {'class': 'my_css_class'}) }}
```

Will produce:

```html
<svg class="sprite sprite-lightbulb my_css_class"...>
  ...
</svg>
```

For a full description of the module, visit the
[project page](https://www.drupal.org/project/svg_sprite).

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/svg_sprite).

## Table of contents

- [Requirements](#requirements)
- [Installation](#installation)
- [Configuration](#configuration)
- [Maintainers](#maintainers)

## Requirements

This module requires no modules outside of Drupal core.

## Installation

Install as you would normally install a contributed Drupal module. For further
information, see
[Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).

## Installation

Install as you would normally install a contributed Drupal module. Visit:
https://www.drupal.org/docs/extending-drupal/installing-drupal-modules for
further information.

## Configuration

Choose the "SVG Sprite" type when creating a field.

## Maintainers

- Frank Mably - [mably](https://www.drupal.org/u/mably)
