/* eslint-disable import/no-unresolved */
/**
 * @file registers the svgSprite toolbar button and binds functionality to it.
 */

import { Plugin } from 'ckeditor5/src/core';
import {
  ButtonView,
  ContextualBalloon,
  clickOutsideHandler,
} from 'ckeditor5/src/ui';
import FormView from './svg_sprite-view';
import icon from '../../../../icons/toolbar.svg';

export default class SvgSpriteUi extends Plugin {
  /**
   * @inheritdoc
   */
  static get requires() {
    return [ContextualBalloon];
  }

  /**
   * @inheritdoc
   */
  init() {
    const { editor } = this;
    const { t } = editor;

    // Create the balloon and the form view.
    this._balloon = this.editor.plugins.get(ContextualBalloon);
    this.formView = this._createFormView();

    editor.ui.componentFactory.add('svgSprite', (locale) => {
      const command = editor.commands.get('insertSvgSprite');
      const buttonView = new ButtonView(locale);

      // Create the toolbar button.
      buttonView.set({
        label: t('SVG Sprite'),
        icon,
        tooltip: true,
      });

      // Bind the state of the button to the command.
      buttonView.bind('isOn', 'isEnabled').to(command, 'value', 'isEnabled');

      // Show the balloon popup when the toolbar button is clicked.
      this.listenTo(buttonView, 'execute', () => {
        this._showUI();
      });

      return buttonView;
    });
  }

  _createFormView() {
    const { editor } = this;
    const formView = new FormView(editor.locale, editor.config);

    // Execute the command when the dropdown item is clicked (executed).
    this.listenTo(formView.spriteDropDownView, 'execute', (evt) => {
      const spriteId = evt.source.commandParam;
      editor.model.change((writer) => {
        editor.execute('insertSvgSprite', {
          name: spriteId,
        });
      });
      this._hideUI();
    });

    // Hide the form view after clicking the "Cancel" button.
    this.listenTo(formView, 'cancel', () => {
      this._hideUI();
    });

    // Hide the form view when clicking outside the balloon.
    clickOutsideHandler({
      emitter: formView,
      activator: () => this._balloon.visibleView === formView,
      contextElements: [this._balloon.view.element],
      callback: () => this._hideUI(),
    });

    return formView;
  }

  _getBalloonPositionData() {
    const { view } = this.editor.editing;
    const viewDocument = view.document;
    let target = null;

    // Set a target position by converting view selection range to DOM.
    target = () =>
      view.domConverter.viewRangeToDom(viewDocument.selection.getFirstRange());

    return {
      target,
    };
  }

  _showUI() {
    this._balloon.add({
      view: this.formView,
      position: this._getBalloonPositionData(),
    });

    this.formView.focus();
  }

  _hideUI() {
    this.formView.element.reset();
    this._balloon.remove(this.formView);

    // Focus the editing view after closing the form view.
    this.editor.editing.view.focus();
  }
}
