/* eslint-disable import/no-unresolved */

import {
  View,
  ViewModel,
  ButtonView,
  submitHandler,
  addListToDropdown,
  createDropdown,
} from 'ckeditor5/src/ui';
import { Collection } from 'ckeditor5/src/utils';
import '../../../../css/svg_sprite_ckeditor5.admin.css';

function getDropdownItemsDefinitions(symbols) {
  const itemDefinitions = new Collection();

  Object.keys(symbols).forEach((id) => {
    const definition = {
      type: 'button',
      model: new ViewModel({
        commandParam: id,
        label: symbols[id],
        withText: true,
      }),
    };
    // Add the item definition to the collection.
    itemDefinitions.add(definition);
  });

  return itemDefinitions;
}

/**
 * A class rendering the information required from user input.
 *
 * @extends module:ui/view~View
 *
 * @internal
 */
export default class SvgSpriteView extends View {
  /**
   * @inheritdoc
   */
  constructor(locale, config) {
    super(locale);

    this.config = config;

    this.spriteDropDownView = this._createSpriteDropDown();

    this.childViews = this.createCollection([this.spriteDropDownView]);

    this.setTemplate({
      tag: 'form',
      attributes: {
        class: ['ck', 'ck-svgsprite-form'],
        tabindex: '-1',
      },
      children: this.childViews,
    });
  }

  /**
   * @inheritdoc
   */
  render() {
    super.render();

    // Submit the form when the user clicked the save button
    // or pressed enter in the input.
    submitHandler({
      view: this,
    });
  }

  /**
   * @inheritdoc
   */
  focus() {
    this.childViews.first.focus();
  }

  _createSpriteDropDown() {
    const dropdownView = createDropdown(this.locale);

    const { t } = this.locale;
    const { symbols } = this.config.get('svgSprite');

    // Populate the list in the dropdown with items.
    if (symbols) {
      addListToDropdown(dropdownView, getDropdownItemsDefinitions(symbols));
      dropdownView.buttonView.set({
        label: t('Select icon'),
        tooltip: true,
        withText: true,
      });
    } else {
      dropdownView.buttonView.set({
        label: t('No icons available'),
        withText: true,
        isEnabled: false,
      });
    }

    return dropdownView;
  }

  // Create a generic button.
  // eslint-disable-next-line class-methods-use-this
  _createButton(label, icon, className) {
    const button = new ButtonView();

    button.set({
      label,
      icon,
      tooltip: true,
      class: className,
    });

    return button;
  }
}
