<?php

namespace Drupal\svg_sprite_ckeditor5\Plugin\CKEditor5Plugin;

use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\ckeditor5\Plugin\CKEditor5PluginConfigurableTrait;
use Drupal\ckeditor5\Plugin\CKEditor5PluginDefault;
use Drupal\editor\EditorInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * CKEditor 5 SvgSprite plugin.
 *
 * @internal
 *   Plugin classes are internal.
 */
class SvgSprite extends CKEditor5PluginDefault implements ContainerFactoryPluginInterface {

  use CKEditor5PluginConfigurableTrait;

  /**
   * The svg_sprite module configuration.
   *
   * @var \Drupal\Core\Config\ImmutableConfig
   */
  protected $config;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    $instance = new self(
      $configuration,
      $plugin_id,
      $plugin_definition,
    );
    $instance->config = $container->get('config.factory')->get('svg_sprite.settings');
    return $instance;
  }

  /**
   * {@inheritdoc}
   */
  public function getDynamicPluginConfig(array $static_plugin_config, EditorInterface $editor): array {
    $config = $static_plugin_config;
    $config['svgSprite']['href'] = $this->config->get('href');
    $config['svgSprite']['symbols'] = $this->config->get('symbols');
    return $config;
  }

}
