<?php

namespace Drupal\svg_sprite\TwigExtension;

use Drupal\svg_sprite\SvgSpriteHelper;
use Drupal\Core\Template\Attribute;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

/**
 * Twig extension to display a svg sprite.
 *
 * @link https://drupaljournal.com/article/drupal/creating-custom-twig-functions-and-filters-drupal
 */
class SvgSpriteExtension extends AbstractExtension {

  /**
   * SVG Sprite twig functions.
   *
   * @return \Twig\TwigFunction[]
   *   TwigFunction array.
   */
  public function getFunctions() {
    return [
      new TwigFunction('svg_sprite',
        $this->displaySvgSprite(...),
        ['is_safe' => ['html']]
      ),
    ];
  }

  /**
   * Provides a render array to display an SVG sprite.
   *
   * @param string $sprite_id
   *   Valid sprite id.
   * @param ?array $attributes
   *   Custom attributes to add to the svg HTML element.
   *
   * @return array|string
   *   NUll or render array of block.
   */
  public function displaySvgSprite(string $sprite_id, ?array $attributes = []) {

    if ($sprite_id) {
      $custom_attributes = empty($attributes) ? NULL : new Attribute($attributes);
      return SvgSpriteHelper::buildSvgSpriteRenderArray($sprite_id, $custom_attributes);
    }

    return '';
  }

}
