# Swagger-PHP OpenAPI 3 documentation generator

## Description

This module uses the `zircote/swagger-php` library to let you document your
Drupal code, and generate an OpenAPI 3 specification and documentation UI, based
on those PHP attributes.

## Installation

- Install this module and its dependencies via Composer.
- Install the `swagger-api/swagger-ui` library in your /libraries folder.
  - See https://www.drupal.org/project/openapi_ui_swagger#installation-composer
  - @todo include instructions here instead of via an external URL.
- Enable the `swagger_php` module
- Use the `zircote/swagger-php` library PHP attributes to document your API,
  e.g. a custom RestResource plugin you have created.

## Example usage

Say we have created a custom RestResource plugin, and want to document this API
endpoint via the OpenAPI 3 specification.

```php
<?php

namespace Drupal\my_custom_api\Plugin\rest\resource;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\rest\Attribute\RestResource;
use Drupal\rest\ModifiedResourceResponse;
use Drupal\rest\Plugin\ResourceBase;
use OpenApi\Attributes as OA;

/**
 * My custom API endpoint.
 */
#[OA\Info(
  version: "1.0.0",
  description: "API documentation for my custom API",
  title: "My Custom API"
)]
#[RestResource(
  id: 'my_custom_resource',
  label: new TranslatableMarkup('Custom API endpoint to send data to.'),
  uri_paths: [
    'create' => '/api/v1/custom/add',
  ],
)]
class MyCustomResource extends ResourceBase {

  /**
   * Responds to POST requests and saves the data.
   */
  #[OA\Post(path: '/api/v1/custom/add', operationId: 'my_custom_resource_add')]
  #[OA\Response(response: '200', description: 'The processed data')]
  public function post(array $data): ModifiedResourceResponse {}

}
```

More information: https://zircote.github.io/swagger-php/

## TODO

- allow multiple folders to scan
- make /api/spec & /api/docs URLs configurable
