/**
 * @file
 * Load Swagger UI on API documentation page.
 */

(function (Drupal, window, SwaggerUIBundle, SwaggerUIStandalonePreset) {
  Drupal.behaviors.swaggerUiLoad = {
    attach: function attach(context, settings) {
      window.onload = function () {
        window.ui = SwaggerUIBundle({
          // @todo make this configurable.
          url: '/' + drupalSettings.path.pathPrefix + 'api/spec',
          dom_id: '#swagger-ui',
          deepLinking: true,
          presets: [SwaggerUIBundle.presets.apis, SwaggerUIStandalonePreset],
        });
      };
    },
  };
})(Drupal, window, drupalSettings, SwaggerUIBundle, SwaggerUIStandalonePreset);
