<?php

declare(strict_types=1);

namespace Drupal\swagger_php\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Form\RedundantEditableConfigNamesTrait;

/**
 * Settings form for Swagger PHP module.
 */
final class SettingsForm extends ConfigFormBase {

  use RedundantEditableConfigNamesTrait;

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'swagger_php_settings';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {
    $form['scan_folder'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Folder to scan'),
      '#description' => $this->t('Specify the folder to scan for OpenAPI PHP attributes'),
      '#config_target' => 'swagger_php.settings:scan_folder',
    ];
    return parent::buildForm($form, $form_state);
  }

}
