<?php

namespace Drupal\swagger_php;

use Drupal\Core\Config\ConfigFactoryInterface;
use OpenApi\Generator;

/**
 * Service to generate OpenAPI specification from PHP attributes.
 */
readonly class OpenApiSpecGenerator {

  /**
   * Constructs a new OpenApiSpecGenerator object.
   *
   * @param \Drupal\Core\Config\ConfigFactoryInterface $configFactory
   *   The config factory.
   */
  public function __construct(private ConfigFactoryInterface $configFactory) {}

  /**
   * Generates the OpenAPI spec in JSON format.
   *
   * @return string|null
   *   The OpenAPI specification in JSON format.
   */
  public function generateJsonSpec(): ?string {
    // Get the configurable path.
    $config = $this->configFactory->get('swagger_php.settings');
    $scan_path = DRUPAL_ROOT . '/' . $config->get('scan_folder');

    // Scan the specified folder using zircote/swagger-php's Generator.
    $openapi = Generator::scan([$scan_path], [
      'exclude' => ['*/.git', '*/.svn', '*/node_modules'],
      'logger' => new SilentLogger(),
    ]);
    return $openapi?->toJson();
  }

}
