<?php

declare(strict_types=1);

namespace Drupal\swagger_php;

use OpenApi\Loggers\DefaultLogger;

/**
 * Logger that overrides Swagger PHP logger, to suppress unneeded warnings.
 */
class SilentLogger extends DefaultLogger {

  /**
   * {@inheritdoc}
   */
  public function warning($message, array $context = []): void {
    // Only log warnings that Do not contain "Skipping unknown".
    if (!str_contains($message, 'Skipping unknown')) {
      parent::warning($message, $context);
    }
  }

}
