<?php

declare(strict_types=1);

namespace Drupal\swiffy_slider\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\Attribute\FieldFormatter;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\text\Plugin\Field\FieldFormatter\TextDefaultFormatter;

/**
 * Plugin implementation of the 'swiffy_slider_text_default' formatter.
 *
 * @coverCodeIgnore
 */
#[FieldFormatter(
  id: 'swiffy_slider_text_default',
  label: new TranslatableMarkup('Swiffy Slider'),
  field_types: [
    'text',
    'text_long',
    'text_with_summary',
  ],
)]
class SwiffySliderTextDefaultFormatter extends TextDefaultFormatter {

  use SwiffySliderFieldFormatterTrait;

}
