<?php

declare(strict_types=1);

namespace Drupal\swiffy_slider;

/**
 * This class exists to avoid code duplication.
 *
 * @internal
 */
final class RenderHelper {

  public static function attachCacheTags(array &$build, ?string $current_value): void {

    if ($current_value !== NULL) {
      return;
    }
    $config = \Drupal::config('swiffy_slider.settings');
    /**
     * @var non-empty-string|null $global_configured_url
     */
    $global_configured_url = $config->get('configuration_url');
    if ($global_configured_url === NULL) {
      return;
    }
    /** @var \Drupal\Core\Render\RendererInterface $renderer */
    $renderer = \Drupal::service('renderer');
    $renderer->addCacheableDependency($build, $config);
  }

}
