# Swup

## Introduction

This module integrates the **Swup.js** library into Drupal.

Swup is a versatile and extensible page transition library that makes your
server-rendered website feel like a **Single Page Application (SPA)** with
smooth transitions between pages.

- Website: https://swup.js.org/
- GitHub: https://github.com/swup/swup

---

## Features

- Smooth page transitions without full page reload
- Improved perceived performance through instant navigation
- Built-in caching for visited pages
- Extensible plugin architecture
- Works with existing server-rendered sites
- No jQuery dependency - pure vanilla JavaScript
- Lightweight (~10KB minified)

---

## Requirements

- Drupal 9.5, 10, or 11
- No external dependencies required (Swup.js is loaded via CDN by default)

---

## Installation

### Standard Installation

1. Download this module: https://www.drupal.org/project/swup
2. Place it under `/modules/contrib/swup`
3. Enable the module through the Drupal admin interface or Drush:

```bash
   drush en swup
```

### Local Library Installation (Optional)

By default, Swup loads from CDN. For local installation:

1. Configure your site's `composer.json` to use Asset Packagist:

```json
  {
    "repositories": [
      {
        "type": "composer",
        "url": "https://asset-packagist.org"
      }
    ],
    "extra": {
      "installer-types": [
        "npm-asset"
      ],
      "installer-paths": {
        "web/libraries/{$name}": [
          "type:npm-asset"
        ]
      }
    }
  }
```
2. Install the Composer plugin and Swup:

```bash
  composer require oomphinc/composer-installers-extender
  composer require npm-asset/swup
```
3. The library will be installed to `/libraries/swup/`

---

## Usage

Swup will be automatically attached to all frontend pages.

### Basic Initialization

Create a custom JavaScript file in your theme to initialize Swup:

```javascript
  (function (Drupal) {

    Drupal.behaviors.swupInit = {
      attach: function (context, settings) {
        // Initialize Swup if not already initialized.
        if (typeof Swup !== 'undefined' && !window.swup) {
          const swup = new Swup({
            containers: ['#main', '#navigation'],
            animateHistoryBrowsing: true,
            animationSelector: '[class*="transition-"]'
          });
          // Store instance for later use.
          window.swup = swup;
        }
      }
    };

  })(Drupal);
```

### Using Plugins

Enable plugins by adding them to your page:

```javascript
  const swup = new Swup({
    plugins: [
      new SwupJsPlugin(),
      new SwupPreloadPlugin(),
      new SwupFormsPlugin()
    ]
  });
```

### CSS Transitions

Add CSS transitions for your page elements:

```css
  .transition-fade {
    opacity: 1;
    transition: opacity 0.25s;
  }
  html.is-animating .transition-fade {
    opacity: 0;
  }
```

For more examples and documentation:
- https://swup.js.org/getting-started/
- https://swup.js.org/getting-started/example/

---

## Configuration

For advanced configuration options, enable the **Swup UI** submodule:

```bash
  drush en swup_ui
```

This provides an admin interface at `/admin/config/user-interface/swup/settings`
where you can:

- Choose between CDN providers (unpkg or jsDelivr)
- Enable/disable specific plugins
- Configure theme-specific loading
- Set path-based visibility rules

---

## Available Plugins

The module supports the following official Swup plugins:

- **JS Plugin** - Run JavaScript for animations
- **Preload Plugin** - Preload pages on hover for faster navigation
- **Scripts Plugin** - Re-evaluate scripts on page change
- **Forms Plugin** - Submit forms via AJAX
- **Debug Plugin** - Debug mode with detailed logs

---

## Troubleshooting

### Pages not transitioning

Ensure your theme has the required containers with IDs that Swup targets:
- Default container is `#main`
- Add more containers in the initialization options

### Scripts not running after transition

Use the Scripts Plugin or listen to Swup events:

```javascript
  swup.hooks.on('page:view', () => {
    // Re-initialize your scripts here
  });
```

---

## MAINTAINERS

The following person is actively maintaining this module:

- **Mahyar Sabeti** ([mahyarsbt](https://www.drupal.org/u/mahyarsbt))

---

## DEMO

- Official examples: https://swup.js.org/getting-started/demos/
- Showcase: https://swup.js.org/showcase/
