<?php

declare(strict_types=1);
namespace Drupal\symfony_form_example\Controller;

use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\FormType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormFactoryInterface;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\RequestStack;

final class SymfonyFormExample1 {

  public function __construct(
    // @todo Consider using FormFactoryBuilder.
    private readonly FormFactoryInterface $formFactory,
  ) {}

  public function build(Request $request) {
    // https://symfony.com/doc/current/forms.html
    // @todo Handle task model.
    // @todo Add form default data.
    $form = $this->createForm(
      options: [
        // Prevent form_div_layout passing null to t() options, throwing.
        'translation_domain' => FALSE,
      ],
    );

    // Thanks to HttpFoundationExtension.
    $form->handleRequest($request);

    if ($form->isSubmitted() && $form->isValid()) {
      // $form->getData() holds the submitted values
      // but, the original `$task` variable has also been updated
      $task = $form->getData();
      // @todo: Save, redirect.
    }

    // @fixme Add form theme
    //   https://symfony.com/doc/current/form/form_themes.html
    //   - use form_div_layout.html.twig
    //   - Add template loader
    return [
      '#type' => 'component',
      '#component' => 'symfony_form:form',
      '#props' => [
        'formView' => $form->createView(),
      ],
    ];
  }

  public function createForm(mixed $data = NULL, array $options = []): FormInterface {
    // @fixme Add CSRF protection.
    //   https://symfony.com/doc/current/security/csrf.html#csrf-protection-in-symfony-forms
    return $this->formFactory->createBuilder(FormType::class, $data, $options)
      ->add('task', TextType::class)
      ->add('dueDate', DateType::class)
      ->add('save', SubmitType::class)
      ->getForm();
  }

}
